block('distribution')(
    def()(function() {
        var maxCount = Number(_.get(this.ctx, 'eventData.max_count'));
        var collectedCount = Number(_.get(this.ctx, 'collectorData.collected_count'));

        return applyNext({
            _collectorData: Object(this.ctx.collectorData),
            _eventData: Object(this.ctx.eventData),
            _availableCount: maxCount - collectedCount
        });
    }),
    js()(function() {
        return {
            collectorData: this._collectorData,
            eventData: this._eventData
        };
    }),
    content()(function() {
        return [
            {
                elem: 'wrap',
                content: [
                    {
                        elem: 'name',
                        content: this._eventData.name
                    },
                    {
                        elem: 'header'
                    },
                    {
                        elem: 'progress'
                    }
                ]
            },
            {
                elem: 'buttons'
            },
            {
                elem: 'rfid-input',
                tag: 'input'
            }
        ];
    })
);
