'use strict';

/**
 * Блок выдачи (пикалка и кнопки)
 * @module distribution
 * @extends i-bem__dom
 * @author annvas
 */
BEM.DOM.decl('distribution', {
    onSetMod: {
        js: function() {
            var pathnameSplitted = location.pathname.split('/').filter(Boolean);
            // Костыль: забирать айди события для запроса независимо от роутинга на бэке
            this._eventId = pathnameSplitted[0] === 'distribution' ? pathnameSplitted[1] : pathnameSplitted[0];
            this._initInput();
        },
        loading: function(modName, modVal) {
            this._progress = this.findBlockOn('progress', 'spin2');

            if (!this._progress) {
                return;
            }

            this._progress.setMod('progress', modVal);
        }
    },
    _getInfo: function() {
        return this.request({
            url: '/api/' + this._eventId + '/info/'
        });
    },
    _initInput: function() {
        this._input = this.findElem('rfid-input');

        setInterval(function () {
            this._input.focus();
        }.bind(this), 250);

        this._input.on('input', _.throttle(this._proceedAuth.bind(this), 1000, {leading: false}));
    },
    _proceedAuth: function() {
        var REPLACEMENT = {
            Ф: 'A',
            И: 'B',
            С: 'C',
            В: 'D',
            У: 'E',
            А: 'F'
        };

        var rfid = String(this._input.val())
            .toUpperCase()
            .replace(/(Ф|И|С|В|У|А)/g, function(m, group) {
                return REPLACEMENT[group];
            });

        this._input.val('');

        this.setMod('loading', 'yes');
        this
            .request({
                url: '/api/' + this._eventId + '/auth/',
                data: {
                    key: rfid
                },
                xhrFields: {
                    withCredentials: true
                }
            })
            .then(function(data) {
                this.delMod('loading');
                this._renderDistribution(data);
                var forms = this.findBlocksInside('s-form');

                if (forms.length) {
                    forms.forEach(function(form) {
                        form.on({
                            success: function() {
                                BEM.DOM.update(this.findElem('header'), 'Готово');
                                BEM.DOM.update(this.findElem('buttons'), '');
                                this.timeout = setTimeout(this._renderDistribution.bind(this), 30000);
                            },
                            error: function(e, data) {
                                e.preventDefault();

                                this._onError(data.response);
                                this.timeout = setTimeout(this._renderDistribution.bind(this), 30000);
                            }
                        }, this);
                    }, this);
                }
            })
            .catch(this._onError);
    },
    _onError: function(error) {
        var errorText = 'Ошибка' + (error.code ? ' ' + error.code : '');

        this.delMod('loading');

        switch (error.error) {
            case 'bad_key':
                errorText = 'Ошибка: некорректный rfid';
                break;
            case 'you_are_not_admin':
                errorText = 'Ошибка: недостаточно прав';
                break;
            case 'locked_key':
                errorText = 'Ошибка: пропуск заблокирован';
                break;
            case 'unlucky':
                errorText = 'Ошибка: сотрудник отсутствует в списке получателей';
                break;
            case 'gift_cannot_be_returned':
                errorText = 'Ошибка: нельзя вернуть предмет';
                break;
        }

        BEM.DOM.update(this.findElem('header'), errorText);
        BEM.DOM.update(this.findElem('buttons'), '');
        console.error('fail', error);
    },
    _renderDistribution: function(data) {
        if (this.timeout) {
            clearTimeout(this.timeout);
        }

        BEM.DOM.update(this.domElem, BEMHTML.apply([
            {
                block: this.constructor.getName(),
                js: true,
                tag: false,
                collectorData: data,
                eventData: this.params.eventData
            }
        ]));

        this._initInput();
    }
});
