block('gift').match(function() {
    return _.isObject(this.ctx.data);
})(
    match(function() {
        return this.ctx.data.error;
    }).content()(function() {
        return JSON.stringify(this.ctx.data);
    }),
    content()(function() {
        var data = this.ctx.data;

        if (data.error) {
            return apply('error');
        } else {
            return [
                data.collected ? apply('collected') : apply('collector'),
                apply('form'),
                apply('logins_collector'),
                apply('logins_collected')
            ];
        }
    }),
    match(function() {
        return this.ctx.data.collector_login;
    }).mode('collector')(function() {
        var data = this.ctx.data;
        if (_.isEmpty(data.collector_for) && (data.collector_login === data.lucky_login)) {
            return {
                elem: 'header',
                content: 'Получает ' + data.collector_login
            };
        } else {
            var logins = Object.keys(data.collector_for);
            var ownGift = (data.collector_login === data.lucky_login) && (logins.indexOf(data.lucky_login) !== -1);
            var headerText = '';

            if (ownGift) {
                headerText = data.himself ? 'Ваш подарок ждёт вас. Кроме вас его никто не сможет получить.' : 'Ваш подарок ждёт вас. При желании ваш подарок может получить ваш коллега.';
            } else {
                headerText = 'Ваш подарок ждёт вас. Его собирается получить ' + data.collector_login + '.';
            }

            return [
                {
                    elem: 'header',
                    content: headerText
                }
            ];
        }
    }),
    match(function() {
        return this.ctx.data.collector_login;
    }).mode('collected')(function() {
        var data = this.ctx.data;
        var ownGift = (data.collector_login === data.lucky_login);

        return {
            elem: 'header',
            content: ownGift ? 'Вы получили свой подарок' : 'Ваш подарок получил ' + data.collector_login
        };
    }),
    match(function() {
        return this.ctx.data.structure;
    }).mode('form')(function() {
        var data = this.ctx.data;
        var form = _.merge({}, data.structure, data.data);

        return {
            block: 's-form',
            js: true,
            url: '/api/' + location.pathname.split('/')[1] + '/prepare/',
            content: [
                Boolean(!form.himself.readonly) && {
                    elem: 'row',
                    content: [
                        {
                            elem: 'caption',
                            content: 'Только я могу забрать свой подарок'
                        },
                        {
                            block: 's-field',
                            mods: {type: 'radio-button'},
                            name: 'himself',
                            field: {
                                value: form.himself.value,
                                choices: [
                                    {
                                        value: true,
                                        label: 'Да'
                                    },
                                    {
                                        value: false,
                                        label: 'Нет'
                                    }
                                ]
                            }
                        }
                    ]
                },
                Boolean(!form.himself.readonly) && {
                    elem: 'row-caption',
                    content: 'Если вы хотите получить свой подарок самостоятельно, нажмите кнопку "Да".'
                },
                {
                    elem: 'row-caption',
                    content: 'Если вам доверили получить подарок, вставьте сюда логины своих коллег. Ниже вы увидите список логинов, для кого вы сможете получить подарки. Если в этом списке отсутствуют какие-то логины, значит человек решил получить подарок сам.'
                },
                {
                    elem: 'row',
                    content: [
                        {
                            elem: 'caption',
                            content: 'Список логинов'
                        },
                        {
                            block: 's-field',
                            mods: {type: 'santa'},
                            name: 'filter_url',
                            field: {
                                value: form.filter_url.value
                            }
                        },
                        {
                            elem: 'buttonset',
                            content: {
                                elem: 'button',
                                elemMods: {
                                    type: 'submit'
                                },
                                buttonMods: {
                                    type: 'submit',
                                    size: 'm'
                                },
                                content: 'Сохранить'
                            }
                        }
                    ]
                }
            ]
        };
    }),
    match(function() {
        return this.ctx.data.error;
    }).mode('error')(function() {
        var error = _.get(this, 'ctx.data.responseJSON.error') || _.get(this, 'ctx.data.error');
        var errorText = 'Ошибка ' + (_.get(this, 'ctx.data.status') || 'загрузки');

        switch (error) {
            case 'bad_key':
                errorText = 'Ошибка: некорректный rfid';
                break;
            case 'you_are_not_admin':
                errorText = 'Ошибка: недостаточно прав';
                break;
            case 'unlucky':
                errorText = 'Ошибка: сотрудник отсутствует в списке получателей';
                break;
        }

        return {
            elem: 'error',
            content: [
                {
                    elem: 'header',
                    content: errorText
                },
                apply('refresh')
            ]
        };
    }),
    match(function() {
        return this.ctx.data;
    }).mode('refresh')(function() {
        return {
            block: 'button2',
            mods: {
                theme: 'normal',
                size: 'm'
            },
            mix: {
                block: this.block,
                elem: 'button-refresh'
            },
            js: true,
            content: 'Обновить'
        };
    }),
    match(function() {
        var data = this.ctx.data;
        // Если будет получать хотя бы один подарок кроме своего.
        return _.isObject(data.collector_for) && Object.keys(data.collector_for).filter(function(login) {
            return login !== data.lucky_login;
        }).length > 0;

    }).mode('logins_collector')(function() {
        var data = this.ctx.data;
        var logins = Object.keys(data.collector_for).filter(function(login) {
            return login !== data.lucky_login;
        });
        var giftsQuantity = logins.length;
        var ownGift = (data.collector_login === data.lucky_login);
        var headerText = '';

        var giftQuantityDeclinated = function(quantity) {
            if (quantity) {
                var lastDigit = (quantity).toString()[(quantity).toString().length - 1];

                if (lastDigit == '1') {
                    return 'подарок';
                } else if (lastDigit > '1' && lastDigit < '5') {
                    return 'подарка';
                } else {
                    return 'подарков';
                }
            } else {
                return '';
            }
        };

        if (ownGift) {
            headerText = 'Вы собираетесь получить свой подарок и ещё ' + giftsQuantity + ' для ';
        } else if (!ownGift) {
            headerText = 'Вы собираетесь получить ' + giftsQuantity + ' ' + giftQuantityDeclinated(giftsQuantity) + ' для ';
        }

        var loginCards = logins.map(function(login) {
            return {
                elem: 'login',
                tag: 'p',
                mix: {
                    block: 'mi-staff-card',
                    js: {user: login}
                },
                content: login
            };
        });

        return {
            elem: 'logins',
            content: [headerText, loginCards]
        };
    }),
    match(function() {
        var data = this.ctx.data;
        // Если получен хотя бы один подарок кроме своего.
        return data.collected_for.filter(function(login) {
            return login !== data.lucky_login;
        }).length > 0;

    }).mode('logins_collected')(function() {
        var data = this.ctx.data;
        var logins = data.collected_for.filter(function(login) {
            return login !== data.lucky_login;
        });
        var giftsQuantity = logins.length;
        var ownGift = (data.collector_login === data.lucky_login);
        var headerText = '';

        var giftQuantityDeclinated = function(quantity) {
            if (quantity) {
                var lastDigit = (quantity).toString()[(quantity).toString().length - 1];

                if (lastDigit == '1') {
                    return 'подарок';
                } else if (lastDigit > '1' && lastDigit < '5') {
                    return 'подарка';
                } else {
                    return 'подарков';
                }
            } else {
                return '';
            }
        };

        if (ownGift) {
            headerText = 'Вы получили свой подарок и ещё ' + giftsQuantity + ' для ';
        } else if (!ownGift) {
            headerText = 'Вы получили ' + giftsQuantity + ' ' + giftQuantityDeclinated(giftsQuantity) + ' для ';
        }

        var loginCards = logins.map(function(login) {
            return {
                elem: 'login',
                tag: 'p',
                mix: {
                    block: 'mi-staff-card',
                    js: {user: login}
                },
                content: login
            };
        });

        return {
            elem: 'logins',
            content: [headerText, loginCards]
        };
    })
);
