'use strict';

BEM.DOM.decl('multi-distribution-menu', {
    onSetMod: {
        js: {
            inited: function () {
                const $items = this.findElem('items');
                const queryParams = new URLSearchParams(window.location.search);
                const requests = queryParams
                    .getAll('code')
                    .map(function (code) {
                        return this.request({
                            url: '/api/' + code + '/info/'
                        });
                    }, this);

                Promise.all(requests)
                    .catch(function () {
                        return [];
                    })
                    .then(function (data) {
                        const html = BEMHTML.apply({
                            block: this.__self.getName(),
                            elem: 'items',
                            data: {
                                distributions: data,
                                from: location.href
                            }
                        });

                        BEM.DOM.replace($items, html);
                    }.bind(this));
            }
        }
    }
});
