block('report-page')(
    mode('head')(function() {
        var bundle = String(this.ctx.bundle);
        var bundlePath = '/static/' + bundle + '/' + bundle;
        var version = String(this.ctx.version);

        return [
            {
                elem: 'css',
                url: bundlePath + '.css?' + version
            },
            {
                elem: 'js',
                url: '//yastatic.net/jquery/2.2.3/jquery.min.js'
            },
            {
                elem: 'js',
                url: '//yastatic.net/lodash/4.10.0/lodash.min.js'
            },
            {
                elem: 'js',
                url: bundlePath + '.js?' + version
            },
            {
                elem: 'js',
                url: bundlePath + '.lang.ru.js?' + version
            },
            {
                elem: 'js',
                url: bundlePath + '.bemhtml.js?' + version
            },
            {
                elem: 'link',
                rel: 'icon',
                type: 'image/png',
                url: '/favicon-16.png',
                sizes: '16x16'
            },
            {
                elem: 'link',
                rel: 'icon',
                type: 'image/png',
                url: '/favicon-32.png',
                sizes: '32x32'
            },
            {
                elem: 'link',
                rel: 'icon',
                type: 'image/png',
                url: '/favicon-64.png',
                sizes: '64x64'
            },
            {
                elem: 'link',
                type: 'image/png',
                rel: 'apple-touch-icon',
                mods: {type: 'apple'},
                url: '/favicon-64.png',
                sizes: '60x60'
            }
        ];
    }),
    mode('title')(function() {
        return 'Яндекс.Подарки';
    }),
    replace()(function() {
        return {
            block: 'b-page',
            mods: {lang: _.get(this.ctx, 'data.lang')},
            mix: {
                block: this.block,
                mods: this.mods,
                js: apply('js') || true
            },
            title: apply('title'),
            head: apply('head'),
            content: [
                ['head', 'content', 'foot'].map(function(elem) {
                    return {
                        block: this.block,
                        mods: this.mods,
                        elem: elem,
                        data: this.ctx.data
                    };
                }, this)
            ]
        };
    })
);
