'use strict';

/**
 * Страница
 * @module report-page
 * @extends i-bem__dom
 * @author annvas
 */
BEM.DOM.decl('report-page', {
    onSetMod: {
        js: function() {
            this._loadReport();
        }
    },
    _renderPage: function(data) {
        BEM.DOM.replace(this.findElem('content'), BEMHTML.apply({
            block: this.constructor.getName(),
            elem: 'content',
            data: data
        }));
    },
    _loadReport: function() {
        var pathnameSplitted = location.pathname.split('/').filter(Boolean);
        // Костыль: забирать айди события для запроса независимо от роутинга на бэке
        var eventId = pathnameSplitted[0] === 'report' ? pathnameSplitted[1] : pathnameSplitted[0];

        $.ajax('/api/' + eventId + '/report/', {
            xhrFields: {
                withCredentials: true
            }
        }).then(function(data) {
            this._renderPage(data);
        }.bind(this)).fail(function(error) {
            console.error('fail', error);
            this._renderPage(error);
        }.bind(this));
    }
});
