block('report-table')(
    content()('Нет данных'),
    match(function() {
        return _.isObject(this.ctx.data) && Array.isArray(this.ctx.data.entries);
    })(
        tag()('table'),
        content()(function() {
            return [
                {
                    elem: 'head',
                    tag: 'thead',
                    content: apply('row', {
                        _cells: [
                            {
                                type: 'head-lucky-login',
                                value: 'Чей подарок'
                            },
                            {
                                type: 'head-collector-login',
                                value: 'Кто забрал'
                            },
                            {
                                type: 'head-collected-time',
                                value: 'Когда'
                            },
                            {
                                type: 'head-collected-count',
                                value: 'Кол-во'
                            },
                            {
                                type: 'head-gift-type-name',
                                value: 'Тип'
                            },
                            {
                                type: 'head-instruction',
                                value: 'Инструкция'
                            }
                        ]
                    })
                },
                {
                    elem: 'body',
                    tag: 'tbody',
                    content: this.ctx.data.entries.map(function(entry) {
                        return apply('row', {
                            _cells: [
                                'lucky_login',
                                'collector_login',
                                'collected_time',
                                'collected_count',
                                'gift_type_name',
                                'instruction'
                            ].map(function(key) {
                                return {
                                    type: key,
                                    value: entry[key]
                                };
                            }, this)
                        });
                    }, this)
                }
            ];
        }),
        mode('row')(function() {
            return {
                elem: 'row',
                tag: 'tr',
                content: this._cells.map(function(cell) {
                    return {
                        elem: 'cell',
                        elemMods: {type: _.kebabCase(cell.type)},
                        tag: 'td',
                        value: cell.value
                    };
                })
            };
        })
    ),
    elem('cell')(
        content()('—'),
        match(function() {
            return this.ctx.value;
        })(
            content()(function() {
                return this.ctx.value;
            }),
            elemMod('type', 'collector-login').content()(function() {
                return apply('user', {_login: this.ctx.value});
            }),
            elemMod('type', 'lucky-login').content()(function() {
                return apply('user', {_login: this.ctx.value});
            }),
            mode('user')(function() {
                return {
                    block: 'm-username',
                    url: 'https://staff.yandex-team.ru/' + this.ctx.value,
                    content: this.ctx.value
                };
            }),
            elemMod('type', 'collected-time').content()(function() {
                return new Date(this.ctx.value).toLocaleString('ru-RU');
            })
        )
    )
);
