BEM.DOM.decl({
    block: 's-field',
    modName: 'type',
    modVal: 'santa'
}, {
    onSetMod: {
        js: {
            inited: function () {
                var that = this;
                that.bSuggest = that.findBlockOn('suggest', 'm-suggest');
                that.$list = that.findElem('list');

                that.bSuggest.on('select', function (event, data) {
                    that.addLogin(data.login);
                    that.bSuggest.clearData();
                });

                // событие прилетает уже после БЭМ-события select,
                // и поле ввода уже очищено после выбора пункта с клавиатуры
                that.bindTo('keydown', function (e) {
                    if (e.keyCode === 13) {
                        // клавиша enter
                        var suggestText = that.bSuggest.val();

                        if (suggestText) {
                            e.preventDefault();
                            e.stopPropagation();

                            /**
                             * Ситуация такова: пользователь ввёл в саджест кучу букв и нажал на Enter. Мы пытаемся
                             * угадать в этой куче букв список логинов (разделители — пробелы, запятая, точка с запятой).
                             *
                             * Чтобы убедиться, что введённое — логины, мы делаем запрос в staff-api.
                             *
                             * То, что staff-api распознал как логины, будет добавлено в список. Всё остальное будет
                             * возвращено в поле ввода саджеста.
                             */
                            that.bSuggest.setMod('disabled', 'yes');
                            var logins = that.bSuggest.val().split(/[,;\s]+/)
                                .filter(Boolean)
                                .reduce(function (res, login) {
                                    res[login] = true;
                                    return res;
                                }, {});

                            if (Object.keys(logins).length) {
                                that._request = $.ajax({
                                    url: 'https://staff-api.yandex-team.ru/v3/persons',
                                    type: 'POST',
                                    xhrFields: {
                                        withCredentials: true
                                    },
                                    data: {
                                        _fields: 'login',
                                        _limit: 1000,
                                        login: Object.keys(logins).join(',')
                                    },
                                    success: function (data) {
                                        if (data && Array.isArray(data.result)) {
                                            data.result.forEach(function (item) {
                                                that.addLogin(item.login);
                                                delete logins[item.login];
                                            });
                                            that.bSuggest.val(Object.keys(logins).join(' '));
                                        }
                                        that.bSuggest.delMod('disabled');
                                    },
                                    error: function () {
                                        that.bSuggest.delMod('disabled');
                                    }
                                });
                            } else {
                                that.bSuggest.clearData();
                                that.bSuggest.delMod('disabled');
                            }
                        }
                    }
                });
            }
        }
    },

    addLogin: function (login) {
        var item = this.$list.find('[data-login=' + JSON.stringify(login) + ']');

        if (item.length) {
            this.findBlockOn(item.eq(0), 'login').setMod('added', 'yes');
        } else {
            BEM.DOM.append(this.$list, BEMHTML.apply({
                block: 'login',
                mods: {added: 'yes'},
                login: login,
                mix: {block: this.__self.getName(), elem: 'login'}
            }));
        }
    },

    val: function () {
        return this.findElem(this.$list, 'login').toArray().map(function (item) {
            return $(item).attr('data-login');
        }).filter(Boolean).join(' ');
    },

    getControl: function () {
        return this.bSuggest.findBlockInside('input').elem('control');
    }
});
