'use strict';

BEM.DOM.decl('s-form', {
    serialize: function () {
        return this.domElem.serializeArray().reduce(function(result, item) {
            if (_.has(result, item.name)) {
                _.set(result, item.name, [].concat(
                    _.get(result, item.name),
                    item.value
                ));
            } else {
                _.set(result, item.name, item.value);
            }

            return result;
        }, {});
    },
    /**
     * Выполняет запрос на сохранение
     * @param {Object} data данные для сохранения
     * @param {Object} [params] параметры для загрузки
     * @return {Promise}
     * @private
     */
    _submit: function (data, params) {
        return this.request($.extend({
            data: data
        }, params), 'submit');
    },
    _getErrors: function (errors) {
        if (Array.isArray(errors)) {
            return errors.map(function (error) {
                return _.isString(error) ? error : error.code;
            }).join('\n');
        } else if (_.isString(errors)) {
            return errors;
        }
    }
});
