module.exports = {
  plugins: ['react-hooks'],
  extends: [
    require.resolve('yandex-lint-draft'),
    require.resolve('yandex-lint-draft/ts')
  ],
  parserOptions: {
    project: './tsconfig.json'
  },
  env: {
    browser: true,
    node: true
  },
  settings: {
    'import/resolver': {
      node: {
        extensions: ['.js', '.jsx', '.ts', '.tsx']
      },
      webpack: {
        config: './webpack-configs/client.config.ts'
      }
    }
  },
  rules: {
    'import/extensions': 0,
    'import/no-extraneous-dependencies': [2, { devDependencies: true }],
    '@typescript-eslint/no-non-null-assertion': 1,
    'react/prefer-stateless-function': 'off',
    'react/jsx-filename-extension': [2, { extensions: ['.jsx', '.tsx'] }],
    '@typescript-eslint/explicit-function-return-type': 2,
    'react-hooks/exhaustive-deps': 1,
    'react-hooks/rules-of-hooks': 1,
    'import/order': [2, {
      "groups": [
        "builtin",
        "external",
        "internal",
        "parent",
        "sibling",
        "index"
      ],
      "newlines-between": "always",
      "warnOnUnassignedImports": true
    }],
    'jsx-a11y/label-has-for': ["error", {
      "required": {
        "some": ["nesting", "id"]
      }
    }],
    'react/jsx-no-target-blank': 0,
    'react/jsx-indent': 'off',
    'react/jsx-indent-props': 'off',
    'react/no-array-index-key': 0,
    '@typescript-eslint/no-empty-function': 0,
    'import/prefer-default-export': 0,
    'react/no-danger': 0
  }
};
