import { OutgoingHttpHeaders } from 'http';

import { Request } from 'express';
import { AppConfig } from '@yandex-int/yandex-cfg';
// eslint-disable-next-line @typescript-eslint/no-unused-vars
import { Logger } from '@yandex-int/yandex-logger';

import './bunker';
import './files/gif';
import './files/jpeg';
import './files/jpg';
import './files/png';
import './files/svg';
import './files/webp';
import './vendors-manifest';

declare global {
    namespace Express {
        interface Request {
            /** Logger instance associated with current request */
            logger: Logger;

            baseUrl: string;

            bunker: Bunker;

            lang: BunkerLang;
        }

        interface Response {
            /**
             * Renders bundle to html, then sends it
             * or performs redirect if necessary
             */
            renderBundle(
                bundleName: string,
                pageName: BunkerPageName,
                data: BundleData
            ): void;
        }
    }

    type BundleData = Pick<
        Request,
        'ip' | 'nonce' | 'secretkey' | 'uatraits' | 'lang'
    > & {
        baseUrl: string;
        debug: boolean;
        isTestingEnv: boolean;
        metrika: MetrikaData;
        pageName: BunkerPageName;
        resHeaders: OutgoingHttpHeaders;
    } & BunkerCommonData;

    type MetrikaData = {
        metrikaId: AppConfig['metrikaCounterId'];
        metrikaOptions: AppConfig['metrikaOptions'];
    };

    type PageData = {
        page: BunkerPageBase & {
            menu: MenuItem[];
            seo: SeoData;
        };
    };

    type MenuItem = {
        id: string;
        titlenav: string;
    };

    type SeoData = {
        title: string;
        description: string;
    };
}
