declare namespace Express {
    interface Request {
        /**
         * Parsed top level domain from host header by express-tld middleware
         *
         * See:
         * https://github.yandex-team.ru/toolbox/express-tld
         */
        tld?: string;
    }
}

declare module '@yandex-int/express-tld' {
    import { RequestHandler } from 'express';

    /**
     * Parses top level domain into req.tld from host header
     *
     * See:
     * https://github.yandex-team.ru/toolbox/express-tld
     */
    function expressTld(): RequestHandler;

    export default expressTld;
}
