declare module '@yandex-int/yandex-cfg' {
    import { ExpressBunkerOptions } from '@yandex-int/express-bunker';
    import { ExpressHttpUatraitsOptions } from '@yandex-int/express-http-uatraits';
    import { ExpressSecretkeyOptions } from '@yandex-int/express-secretkey';
    import { IOptions as ExpressTvmOptions } from '@yandex-int/express-tvm';
    import { ExpressXForwardedForFixOptions } from '@yandex-int/express-x-forwarded-for-fix';
    import { ExpressYandexCspOptions } from '@yandex-int/express-yandex-csp';
    import { ExpressYandexuidOptions } from '@yandex-int/express-yandexuid';
    import { LoggerOptions } from '@yandex-int/yandex-logger';
    import { IHelmetConfiguration } from 'helmet';

    interface Config {
        /**
         * Options for express-bunker middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-bunker
         */
        bunker?: ExpressBunkerOptions;

        /**
         * Options for express-yandex-csp middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-yandex-csp
         */
        csp?: ExpressYandexCspOptions;

        /**
         * Option for environment detection
         */
        environment: string;

        /**
         * Options for helmet middleware
         *
         * Source code:
         * https://github.com/helmetjs/helmet
         */
        helmet?: IHelmetConfiguration;

        /**
         * Options for express-http-uatraits middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-http-uatraits
         */
        httpUatraits?: ExpressHttpUatraitsOptions;

        i18n: {
            /** Languages for which source code should be built */

            langs: string[];

            /** TLD matching to a specific language */
            tldToLang: {
                [tld: string]: string;
            };
        };

        /**
         * Options for yandex-logger
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/yandex-logger
         */
        logger: LoggerOptions;

        metrikaCounterId?: number;

        metrikaOptions: {
            clickmap?: boolean;
            trackLinks?: boolean;
            webvisor?: boolean;
            accurateTrackBounce?: boolean;
        };

        /** Render options */
        render?: {
            /** Turns hot module replacement */
            isHot: boolean;
        };

        /**
         * Options for express-secretkey middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-secretkey
         */
        secretkey?: ExpressSecretkeyOptions;

        /** Static content (built css and js, images, etc) options */
        static: {
            /** Base url for static content (e.g. https://yastatic.net/s3/project-stub/) */
            baseUrl: string;

            /** Directory for the built static content */
            dir: string;

            /** Path to frozen (version agnostic) static content (e.g. "_") */
            frozenPath: string;

            /** Directory for static files, which should be served from / */
            staticDir: string;

            /** Path to version static content (usually picked from env) */
            version: string;
        };

        /**
         * Options for express-tvm middleware
         *
         * More information:
         * https://wiki.yandex-team.ru/passport/tvm2/qloud/#/tvm/tickets
         */
        tvm: ExpressTvmOptions;

        /**
         * Options for express-x-forwarded-for-fix middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-x-forwarded-for-fix
         */
        xForwardedForFix?: ExpressXForwardedForFixOptions;

        /**
         * Options for express-yandexuid middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-yandexuid
         */
        yandexuid?: ExpressYandexuidOptions;
    }

    // eslint-disable no-use-before-define
    type RecursivePartial<T> = {
        [P in keyof T]?: RecursivePartial<T[P]>;
    };
    // eslint-enable no-use-before-define

    export type AppConfig = RecursivePartial<Config>;

    const config: Config;
    export default config;
}
