import React, { Component, Fragment } from 'react';
import { hydrate } from 'react-dom';
import Helmet from 'react-helmet';
import { hot } from 'react-hot-loader/root';
import { BrowserRouter } from 'react-router-dom';

import App from '../components/app/app';
import Debug from '../components/debug';
import LangContext from '../utils/lang-context';

import { BundleProps } from './types';

class Bundle extends Component<BundleProps> {
    render(): JSX.Element {
        const { data } = this.props;
        const image = data.common.seo.ogimage;

        return (
            <Fragment>
                <Helmet>
                    <html lang="en" />
                    <meta
                        name="viewport"
                        content="width=device-width, initial-scale=1.0"
                    />
                    <link rel="canonical" href={data.baseUrl} />

                    <meta property="og:url" content={data.baseUrl} />
                    <meta property="og:type" content="website" />
                    <meta property="og:image" content={image} />
                    <meta property="og:image:width" content="1200" />
                    <meta property="og:image:height" content="630" />

                    <meta name="twitter:card" content={image} />

                    <link
                        rel="shortcut icon"
                        href="https://yastatic.net/s3/home-static/_/a5/a557b72322add07a6b41fc8f71cfffc8.png"
                        sizes="16x16"
                    />
                    <link
                        rel="shortcut icon"
                        href="https://yastatic.net/s3/home-static/_/92/929b10d17990e806734f68758ec917ec.png"
                        sizes="32x32"
                    />
                    <link
                        rel="shortcut icon"
                        href="https://yastatic.net/s3/home-static/_/7c/7ccfee6f1e81b14c5bef535d1ad7b7e0.png"
                        sizes="192x192"
                    />
                    <link
                        rel="apple-touch-icon"
                        href="https://yastatic.net/s3/home-static/_/64/64f5920e670ad193dcca0ed33500c7c4.png"
                        sizes="76x76"
                    />
                    <link
                        rel="apple-touch-icon"
                        href="https://yastatic.net/s3/home-static/_/dd/dd7dd21686a67bfa46910039ead07a04.png"
                        sizes="120x120"
                    />
                    <link
                        rel="apple-touch-icon"
                        href="https://yastatic.net/s3/home-static/_/75/759c668aa6747fee858fb5ae0c207474.png"
                        sizes="152x152"
                    />
                    <link
                        rel="apple-touch-icon"
                        href="https://yastatic.net/s3/home-static/_/90/9034470dfcb0bea0db29a281007b8a38.png"
                        sizes="180x180"
                    />
                </Helmet>

                <LangContext.Provider
                    value={{
                        lang: data.lang,
                        dictionary: data.dictionary
                    }}
                >
                    <App {...this.props} />
                </LangContext.Provider>

                <Debug {...this.props} />
            </Fragment>
        );
    }
}

export const CommonBundle = hot(Bundle);

export default (data: BundleProps['data']): void => {
    hydrate(
        <BrowserRouter>
            <CommonBundle data={data} />
        </BrowserRouter>,
        document.getElementById('mount')
    );
};
