export interface BundleProps {
    data: BundleData & PageData;
}

export interface MenuHeaderItem {
    url: string;
    title: string;
    isCurrent?: boolean;
}

export interface Menu {
    sections: MenuListItem[];
    report: ReportData;
}

export interface MenuListItem {
    id: string;
    subtitle: string;
    items: MenuItem[];
    view: 'footer' | 'header' | 'nav';
    isCurrent?: boolean;
}

export interface MenuItem {
    id: string;
    url: string;
    title: string;
    isCurrent?: boolean;
}

export interface ReportData {
    title: string;
    url: string;
    size?: string;
}

export interface FooterData {
    menu: MenuListItem[];
    contacts: {
        email: string;
    };
    links: {
        terms: {
            title: string;
            url: string;
        };
    };
}
