import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Title from 'client/components/title';

import './index.css';

const b = cn('accordion-item');

interface Props {
    item: TextItem;
    theme: 'white' | 'light-grey';
}

interface State {
    isItemOpened: boolean;
}

export default class AccordionItem extends Component<Props, State> {
    constructor(props: Props) {
        super(props);

        this.state = {
            isItemOpened: false
        };
    }

    toggleItem = (): void => {
        const { isItemOpened } = this.state;

        this.setState({ isItemOpened: !isItemOpened });
    };

    render(): React.ReactNode {
        const { item, theme } = this.props;
        const { isItemOpened } = this.state;

        return (
            <section className={b({ opened: isItemOpened, theme })}>
                <button
                    className={b('button-title')}
                    type="button"
                    onClick={this.toggleItem}
                    aria-expanded={isItemOpened}
                >
                    <div className={b('title')}>
                        <Title h3={item.title} />
                    </div>

                    <span className={b('icon-expand')} />
                </button>

                <div
                    className={b('text')}
                    dangerouslySetInnerHTML={{ __html: item.text }}
                />
            </section>
        );
    }
}
