import React, { Component } from 'react';

import cn from 'client/utils/cn';
import AccordionItem from 'client/components/accordion-item';

const b = cn('accordion');

interface Props {
    items: TextItem[];
    title?: string;
    theme: 'white' | 'light-grey';
}

export default class Accordion extends Component<Props> {
    render(): React.ReactNode {
        const { items, theme } = this.props;

        return (
            <article className={b()}>
                {items.map((item, i) => (
                    <AccordionItem item={item} key={i} theme={theme} />
                ))}
            </article>
        );
    }
}
