import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Footer from 'client/components/footer';
import Header from 'client/components/header';
import Metrika from 'client/components/metrika';
import { BundleProps } from 'client/bundles/types';
import LangContext from 'client/utils/lang-context';
import AccessiblePage from 'client/pages/accessible';
import AgendaPage from 'client/pages/agenda';
import AnticorruptionPage from 'client/pages/anticorruption';
import CarbonPage from 'client/pages/carbon';
import ConveniencePage from 'client/pages/convenience';
import EducationPage from 'client/pages/education';
import EmployeesPage from 'client/pages/employees';
import EnergyPage from 'client/pages/energy';
import FaqPage from 'client/pages/faq';
import DownloadPage from 'client/pages/download';
import DownloadWebcastPage from 'client/pages/download-webcast';
import MainPage from 'client/pages/main';
import NotFoundPage from 'client/pages/not-found';
import PartnersPage from 'client/pages/partners';
import ProcurementPage from 'client/pages/procurement';
import QualityPage from 'client/pages/quality';
import SecurityPage from 'client/pages/security';
import WastePage from 'client/pages/waste';

import './app.css';

const b = cn('app');

interface State {
    isMenuOpened: boolean;
}

const PAGES: Record<BunkerPageName, typeof Component> = {
    accessible: AccessiblePage,
    agenda: AgendaPage,
    anticorruption: AnticorruptionPage,
    education: EducationPage,
    employees: EmployeesPage,
    faq: FaqPage,
    download: DownloadPage,
    'download[webcast]': DownloadWebcastPage,
    convenience: ConveniencePage,
    main: MainPage,
    'not-found': NotFoundPage,
    partners: PartnersPage,
    procurement: ProcurementPage,
    quality: QualityPage,
    security: SecurityPage,
    energy: EnergyPage,
    carbon: CarbonPage,
    waste: WastePage
};

class App extends Component<BundleProps, State> {
    constructor(props: BundleProps) {
        super(props);

        this.state = {
            isMenuOpened: false
        };
    }

    onNavToggled = (isMenuOpened: boolean): void => {
        this.setState({ isMenuOpened });
    };

    static contextType = LangContext;

    render(): JSX.Element {
        const { data } = this.props;
        const { isMenuOpened } = this.state;
        const PageContent = PAGES[data.pageName];
        const isMainPage = data.pageName === 'main';

        return (
            <div className={b({ hidden: isMenuOpened })}>
                <Header
                    common={data.common}
                    isMenuOpened={isMenuOpened}
                    onNavToggled={this.onNavToggled}
                    mainPage={isMainPage}
                />

                <div className={b('content', { 'main-page': isMainPage })}>
                    <PageContent
                        data={data.page}
                        common={data.common}
                        isMenuOpened={isMenuOpened}
                        onNavToggled={this.onNavToggled}
                    />
                </div>

                <Footer common={data.common} />

                <Metrika metrika={data.metrika} />
            </div>
        );
    }
}

export default App;
