import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Card from 'client/components/card';
import HintIcon from 'client/components/hint-icon';

import './index.css';

const b = cn('card-digit');

interface Props {
    data: CardDigitData;
    theme: 'white' | 'light-grey';
}

export default class CardDigit extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: { pre, num, text, tooltip },
            theme
        } = this.props;

        return (
            <Card theme={theme} location="inner" stretched>
                <div className={b()} aria-hidden="true">
                    {pre && <div className={b('pre')}>{pre}</div>}

                    <div className={b('main')}>
                        <div className={b('num')}>{num}</div>

                        {tooltip && (
                            <div className={b('hint-icon')}>
                                <HintIcon
                                    hint={tooltip}
                                    mixClassName={b('hint')}
                                    width={250}
                                />
                            </div>
                        )}
                    </div>

                    {text && (
                        <div
                            className={b('text', ['text'])}
                            dangerouslySetInnerHTML={{ __html: text }}
                        />
                    )}
                </div>

                <div className="visually-hidden">
                    {pre || null} {num}
                    {text && (
                        <>
                            ({' '}
                            <span dangerouslySetInnerHTML={{ __html: text }} />)
                        </>
                    )}
                    {tooltip ? (
                        <>
                            ({' '}
                            <span
                                dangerouslySetInnerHTML={{ __html: tooltip }}
                            />
                            )
                        </>
                    ) : null}
                </div>
            </Card>
        );
    }
}
