import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Card from 'client/components/card';
import Doc from 'client/components/doc';
import Icon from 'client/components/icon';
import LangContext from 'client/utils/lang-context';
import LinkItem from 'client/components/link';
import Title from 'client/components/title';
import 'client/components/text/index.css';

import './index.css';

const b = cn('card-fact');

interface Props {
    theme: 'white' | 'light-grey';
    children?: React.ReactNode | null;
    location?: 'inner' | undefined;
    stretched?: boolean;
    icon?: string;
    iconSize?: '32' | '52';
    title?: string;
    text?: string;
    popup?: string;
    doc?: DocItem;
    url?: string;
    nodecorate?: boolean;
}

export default class CardFact extends Component<Props> {
    static contextType = LangContext;

    render(): React.ReactNode {
        const {
            children,
            icon,
            iconSize,
            location,
            title,
            text,
            theme,
            stretched,
            nodecorate,
            popup,
            url,
            doc
        } = this.props;
        const { dictionary } = this.context;

        return (
            <Card
                theme={theme}
                location={location}
                stretched={stretched}
                nodecorate={nodecorate}
            >
                <div className={b()}>
                    <div className={b('content')}>
                        {icon && iconSize && (
                            <div className={b('icon-wrapper')}>
                                <Icon type={icon} size={iconSize} />
                            </div>
                        )}
                        {title && (
                            <div className={b('title')}>
                                <Title h3={title} />
                            </div>
                        )}
                        {text && (
                            <div
                                className={b('text', ['text'])}
                                dangerouslySetInnerHTML={{ __html: text }}
                            />
                        )}
                        {popup && (
                            <div className={b('popup')}>
                                <LinkItem
                                    text={dictionary.continue}
                                    popup={popup}
                                    title={title}
                                    icon="inside"
                                />
                            </div>
                        )}

                        {children}
                    </div>

                    {url && (
                        <div className={b('link')}>
                            <LinkItem
                                href={url}
                                text={dictionary.more}
                                icon="inside"
                            />
                        </div>
                    )}

                    {doc && doc.name && doc.url && (
                        <div className={b('doc')}>
                            <Doc
                                theme="light-grey"
                                name={doc.name}
                                url={doc.url}
                            />
                        </div>
                    )}
                </div>
            </Card>
        );
    }
}
