import React, { Component } from 'react';

import cn from 'client/utils/cn';

import './index.css';

const b = cn('card');

interface Props {
    theme: 'white' | 'light-grey';
    wide?: boolean;
    location?: 'inner' | undefined;
    children?: React.ReactNode | string;
    stretched?: boolean;
    nodecorate?: boolean;
    hint?: boolean;
}

export default class Card extends Component<Props> {
    render(): React.ReactNode {
        const { theme, stretched, children, location, wide, nodecorate, hint } =
            this.props;

        return (
            <div
                className={b({
                    theme,
                    location,
                    stretched,
                    wide,
                    nodecorate,
                    hint
                })}
            >
                {children}
            </div>
        );
    }
}
