import React, { Component } from 'react';

import cn from 'client/utils/cn';
import { BundleProps } from 'client/bundles/types';

import './index.css';

const b = cn('debug');

class Debug extends Component<BundleProps> {
    render(): JSX.Element | null {
        const { data } = this.props;

        if (!data.debug || !data.isTestingEnv) {
            return null;
        }

        return <pre className={b()}>{JSON.stringify(data, null, 2)}</pre>;
    }
}

export default Debug;
