import React, { Component } from 'react';

import cn from 'client/utils/cn';
import CardFact from 'client/components/card-fact';
import Icon from 'client/components/icon';
import ImageCard from 'client/components/image-card';
import SectionGridRow from 'client/components/section-grid-row';
import Title from 'client/components/title';

import './index.css';

const b = cn('developing-leaders');

interface Props {
    items: DevelopingSectionItems;
}

export default class DevelopingLeaders extends Component<Props> {
    renderService = (
        service: DevelopingServicesItem,
        i: number
    ): React.ReactNode => {
        return (
            <li className={b('service')} key={`service-${i}`}>
                {service.icon && (
                    <Icon size="16" type={service.icon} title={service.title} />
                )}
                {service.title}
            </li>
        );
    };

    renderServicesGroup = (
        group: DevelopingServicesGroup,
        i: number
    ): React.ReactNode => {
        return (
            <div className={b('services-group')} key={`services-group-${i}`}>
                <Title h4={group.title} />

                <ul className={b('services')}>
                    {group.services.map(this.renderService)}
                </ul>
            </div>
        );
    };

    render(): React.ReactNode {
        const {
            items: { left, right }
        } = this.props;

        return (
            <div className={b()}>
                <SectionGridRow>
                    <div className={b('left')}>
                        <CardFact
                            theme="white"
                            title={left.title}
                            text={left.text}
                            icon="handshake"
                            iconSize="52"
                            stretched
                            popup={left.popup}
                        >
                            {left.image && (
                                <ImageCard
                                    src={left.image}
                                    title={left.title}
                                    hidden
                                />
                            )}
                        </CardFact>
                    </div>

                    <div className={b('right')}>
                        <CardFact
                            theme="white"
                            title={right.title}
                            text={right.text}
                            icon="handshake"
                            iconSize="52"
                            stretched
                            popup={right.popup}
                        >
                            <div className={b('services-groups')}>
                                {right.services.map(this.renderServicesGroup)}
                            </div>
                        </CardFact>
                    </div>
                </SectionGridRow>
            </div>
        );
    }
}
