import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Icon from 'client/components/icon';

import './index.css';

const b = cn('doc');

interface Props {
    theme: 'white' | 'grey' | 'light-grey';
    url: string;
    name: string;
    format?: string;
    size?: string;
}

export default class Doc extends Component<Props> {
    render(): React.ReactNode {
        const { theme, url, name, format, size } = this.props;

        return (
            <a href={url} target="_blank" className={b({ theme })}>
                <Icon type="doc" size="36" />

                <span className={b('inner')}>
                    <span className={b('name')}>{name}</span>

                    {(format || size) && (
                        <span className={b('info')}>
                            {size && <span className={b('size')}>{size}</span>}
                            {format && (
                                <span className={b('format')}>{format}</span>
                            )}
                        </span>
                    )}
                </span>
            </a>
        );
    }
}
