import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Doc from 'client/components/doc';

import './index.css';

const b = cn('docs');

interface Props {
    theme: 'white' | 'grey';
    items: DocItem[];
    view?: 'column' | undefined;
    format?: 'pdf' | 'web' | undefined;
    size?: string;
}

export default class Docs extends Component<Props> {
    renderItem = (doc: DocItem, i: number): React.ReactNode => {
        const { theme } = this.props;

        return (
            <li className={b('item')} key={i}>
                <Doc
                    url={doc.url}
                    name={doc.name}
                    theme={theme}
                    format={doc.format}
                    size={doc.size}
                />
            </li>
        );
    };

    render(): React.ReactNode {
        const { items, view } = this.props;

        if (!items || items.length === 0) {
            return null;
        }

        return <ul className={b({ view })}>{items.map(this.renderItem)}</ul>;
    }
}
