import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Docs from 'client/components/docs';
import Title from 'client/components/title';

import './index.css';

const b = cn('download-years');

interface Props {
    years: BunkerPageDownload['years'];
}

export default class DownloadYears extends Component<Props> {
    renderYear = (yearItem: DownloadYear, i: number): React.ReactNode => {
        return (
            <section className={b('year')} key={i}>
                <div className={b('title')}>
                    <Title h2={yearItem.year} />
                </div>

                <Docs items={yearItem.docs.items} theme="white" view="column" />
            </section>
        );
    };

    render(): React.ReactNode {
        const { years } = this.props;

        if (years.length === 0) {
            return null;
        }

        return <div className={b()}>{years.map(this.renderYear)}</div>;
    }
}
