import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Card from 'client/components/card';
import TabsPanes from 'client/components/tabs-panes';

import './index.css';

const b = cn('employee-engagement');

interface Props {
    engagement: WorkforceEngagement;
}

export default class EmployeeEngagement extends Component<Props> {
    renderNavItem = (item: CardTabsItem): React.ReactNode => {
        return <div className={b('text')}>{item.title}</div>;
    };

    renderNavContent = (item: CardTabsItem): React.ReactNode => {
        return <div className={b('content')}>{item.text}</div>;
    };

    render(): React.ReactNode {
        const { engagement } = this.props;

        if (engagement.items.length === 0) {
            return null;
        }

        const itemsPepared = engagement.items.map((item) => {
            return {
                nav: this.renderNavItem(item),
                content: this.renderNavContent(item)
            };
        });

        const activeTabIndex = engagement.items.findIndex((item) => {
            return item.isActive;
        });

        return (
            <Card theme="white" location="inner" stretched>
                <div className={b()}>
                    <TabsPanes
                        items={itemsPepared}
                        nav="bottom"
                        isActive={activeTabIndex}
                    />

                    <div className={b('description')}>
                        {engagement.description}
                    </div>
                </div>
            </Card>
        );
    }
}
