import React, { Component } from 'react';

import cn from 'client/utils/cn';
import LangContext from 'client/utils/lang-context';
import Logo from 'client/components/logo';
import MenuLinks from 'client/components/menu-links';
import MenuSiteSections from 'client/components/menu-site-sections';

import './index.css';

const b = cn('footer');

interface Props {
    common: BunkerCommon;
}

class Footer extends Component<Props> {
    static getCurrentYear(): string {
        return new Date().getFullYear().toString();
    }

    static contextType = LangContext;

    render(): JSX.Element {
        const {
            common: { title, menu, yandexMainPage, footer, agenda, links }
        } = this.props;
        const { dictionary } = this.context;

        return (
            <footer className={b()}>
                <div className={b('content')}>
                    <div className={b('row')}>
                        <Logo
                            theme="white"
                            title={title}
                            yandexMainPage={yandexMainPage}
                        />

                        <div className={b('links')}>
                            <a className={b('link')} href={agenda.url}>
                                {agenda.title}
                            </a>

                            <MenuLinks links={links} view="footer" />
                        </div>
                    </div>

                    <div className={b('row')}>
                        <MenuSiteSections items={menu.sections} view="footer" />
                    </div>

                    <div className={b('row')}>
                        <div className={b('contacts')}>
                            <div className={b('contacts-label')}>
                                {`${dictionary.contacts}:`}
                            </div>
                            <a
                                className={b('primary-link')}
                                href={`mailto:${footer.contacts.email}`}
                            >
                                {footer.contacts.email}
                            </a>
                        </div>
                    </div>
                    <div className={b('row')}>
                        <div className={b('copyright')}>
                            &copy;&nbsp;1997–
                            {Footer.getCurrentYear()}
                            &nbsp;&nbsp;
                            <a
                                className={b('secondary-link')}
                                href={yandexMainPage}
                            >
                                {dictionary.yandex}
                            </a>
                        </div>
                        <div className={b('terms')}>
                            <a
                                className={b('secondary-link')}
                                href={footer.links.terms.url}
                            >
                                {footer.links.terms.title}
                            </a>
                        </div>
                    </div>
                </div>
            </footer>
        );
    }
}

export default Footer;
