import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Icon from 'client/components/icon';
import Hint from 'client/components/hint';

import './index.css';

const b = cn('hint-icon');

interface Props {
    hint: string;
    width: number;
    mixClassName: string;
}

export default class HintIcon extends Component<Props> {
    private nodeRef = React.createRef<HTMLDivElement>();

    componentDidMount(): void {
        // Прокидываем актуальный nodeRef в Hint после отрисовки
        this.forceUpdate();
    }

    render(): React.ReactNode {
        const { hint, width, mixClassName } = this.props;

        return (
            <div className={b()}>
                <div className={b('icon')}>
                    <Icon type="hint" size="16" />
                </div>

                <Hint
                    content={hint}
                    mixClassName={mixClassName}
                    parentNode={this.nodeRef.current}
                    width={width}
                />
            </div>
        );
    }
}
