import React, { Component } from 'react';

import cn from 'client/utils/cn';

import './index.css';

const b = cn('icon');

interface Props {
    type: string | undefined;
    size: '16' | '32' | '36' | '44' | '52';
    title?: string | undefined;
}

export default class Icon extends Component<Props> {
    render(): React.ReactNode {
        const { type, size, title } = this.props;

        if (!type) {
            return null;
        }

        return <span className={b({ type, size })} title={title} />;
    }
}
