import React, { Component } from 'react';

import cn from 'client/utils/cn';

import './index.css';

const b = cn('image-card');

interface Props {
    title: string;
    src: string;
    hidden?: boolean;
}

export default class ImageCard extends Component<Props> {
    render(): React.ReactNode {
        const { title, src, hidden } = this.props;

        if (!src) {
            return null;
        }

        return (
            <img
                className={b()}
                alt={`${title} Illustration`}
                src={src}
                aria-hidden={hidden}
            />
        );
    }
}
