import React, { Component } from 'react';

import cn from 'client/utils/cn';
import LangContext from 'client/utils/lang-context';

import './index.css';

const b = cn('logo');

interface Props {
    theme: 'black' | 'white';
    title: string;
    yandexMainPage: string;
}

class Logo extends Component<Props> {
    static contextType = LangContext;

    render(): JSX.Element {
        const { theme, title, yandexMainPage } = this.props;
        const { lang, dictionary } = this.context;

        return (
            <div className={b({ theme })}>
                <div className={b('icon', { lang })}>
                    <a className={b('link')} href={yandexMainPage}>
                        {dictionary.yandex}
                    </a>
                </div>

                <div className={b('service')}>
                    <a className={b('service-link')} href="/" rel="nofollow">
                        {title}
                    </a>
                </div>
            </div>
        );
    }
}

export default Logo;
