import React, { Component } from 'react';

import cn from 'client/utils/cn';
import { MenuHeaderItem } from 'client/bundles/types';

import './index.css';

const b = cn('menu-links');

interface Props {
    links: BunkerCommon['links'];
    view: 'nav' | 'header' | 'footer';
}

class MenuLinks extends Component<Props> {
    renderLink = (link: MenuHeaderItem, i: number): React.ReactNode => {
        return (
            <div
                className={b('item', { active: link.isCurrent })}
                key={`link-item-${i}`}
            >
                <a href={link.url} className={b('link')}>
                    <span className={b('link-text')}>{link.title}</span>
                </a>
            </div>
        );
    };

    render(): React.ReactNode {
        const { links, view } = this.props;

        if (links.length === 0) {
            return null;
        }

        return <div className={b({ view })}>{links.map(this.renderLink)}</div>;
    }
}

export default MenuLinks;
