import React, { Component } from 'react';

import cn from 'client/utils/cn';
import MenuSiteSections from 'client/components/menu-site-sections';
import ReportDownload from 'client/components/report-download';

import './index.css';

const b = cn('menu-site');

interface Props {
    menu: BunkerCommon['menu'];
    agenda: BunkerCommon['agenda'];
    report: BunkerCommon['report'];
}

class MenuSite extends Component<Props> {
    render(): React.ReactNode {
        const { menu, report, agenda } = this.props;

        return (
            <div className={b()}>
                <div className={b('content')}>
                    <div className={b('left')}>
                        <MenuSiteSections
                            items={menu.sections}
                            agenda={agenda}
                            view="header"
                        />
                    </div>

                    <div className={b('right')}>
                        <ReportDownload report={report} />
                    </div>
                </div>
            </div>
        );
    }
}

export default MenuSite;
