import React, { Component } from 'react';

import cn from 'client/utils/cn';
import MenuLinks from 'client/components/menu-links';
import MenuSiteSections from 'client/components/menu-site-sections';
import ReportDownload from 'client/components/report-download';

import './index.css';

const b = cn('nav');

interface Props {
    menu: BunkerCommon['menu'];
    links: BunkerCommon['links'];
    agenda: BunkerCommon['agenda'];
    report: BunkerCommon['report'];
    isMenuOpened: boolean;
}

class Nav extends Component<Props> {
    render(): React.ReactNode {
        const { menu, report, agenda, links, isMenuOpened } = this.props;

        return (
            <nav className={b({ opened: isMenuOpened })}>
                {isMenuOpened && (
                    <div className={b('inner')}>
                        <div className={b('top')}>
                            <ReportDownload report={report} />
                        </div>

                        <div className={b('main')}>
                            <MenuSiteSections
                                items={menu.sections}
                                agenda={agenda}
                                view="nav"
                            />
                        </div>

                        {links && links.length > 0 && (
                            <div className={b('bottom')}>
                                <div className={b('links')}>
                                    <MenuLinks links={links} view="nav" />
                                </div>
                            </div>
                        )}
                    </div>
                )}
            </nav>
        );
    }
}

export default Nav;
