import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Title from 'client/components/title';
import 'client/components/text/index.css';

import './index.css';

const b = cn('notes');

interface Props {
    title: string;
    items: NotesItem[];
}

export default class Notes extends Component<Props> {
    renderItem = (item: NotesItem, index: number): React.ReactNode => {
        return (
            <li key={index} className={b('item')}>
                {item.title && (
                    <div className={b('item-title')}>
                        <Title h4={item.title} url={item.url} />
                    </div>
                )}

                {item.text && (
                    <div
                        className={b('text', ['text'])}
                        dangerouslySetInnerHTML={{ __html: item.text }}
                    />
                )}
            </li>
        );
    };

    render(): React.ReactNode {
        const { items, title } = this.props;

        if (items.length === 0) {
            return null;
        }

        if (items.length % 2 > 0) {
            items.push({ text: '' });
        }

        return (
            <div className={b()}>
                <div className={b('title')}>
                    <Title h4={title} />
                </div>

                <ul className={b('items')}>{items.map(this.renderItem)}</ul>
            </div>
        );
    }
}
