import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Card from 'client/components/card';
import Partner from 'client/components/partners-list/partner';

import './index.css';

const b = cn('partners-list');

interface Props {
    partners: BunkerPagePartners['sections']['partners'];
}

export default class PartnersList extends Component<Props> {
    render(): React.ReactNode {
        const { partners } = this.props;

        return (
            <Card theme="white">
                <div className={b()}>
                    {partners.items.map((item: TextItem, i: number) => (
                        <Partner item={item} key={i} />
                    ))}

                    <span className={b('others')}>{partners.others}</span>
                </div>
            </Card>
        );
    }
}
