import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Hint from 'client/components/hint';
import Icon from 'client/components/icon';

import './index.css';

const b = cn('partner');

interface Props {
    item: TextItem;
}

export default class Partner extends Component<Props> {
    private nodeRef = React.createRef<HTMLDivElement>();

    componentDidMount(): void {
        // Прокидываем актуальный nodeRef в Hint после отрисовки
        this.forceUpdate();
    }

    render(): React.ReactNode {
        const { item } = this.props;

        return (
            <div className={b()} ref={this.nodeRef}>
                <span className={b('button')}>
                    {item.title}

                    {item.tooltip && (
                        <>
                            <span className={b('icon')}>
                                <Icon type="hint" size="16" />
                            </span>

                            <Hint
                                content={item.tooltip}
                                mixClassName={b('hint')}
                                parentNode={this.nodeRef.current}
                                width={288}
                            />
                        </>
                    )}
                </span>
            </div>
        );
    }
}
