import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Card from 'client/components/card';
import CardDigit from 'client/components/card-digit';
import HintIcon from 'client/components/hint-icon';
import SectionGridRow from 'client/components/section-grid-row';
import Title from 'client/components/title';

import './index.css';

const b = cn('practicum');

interface Props {
    data: PracticumFacts;
}

export default class Practicum extends Component<Props> {
    render(): React.ReactNode {
        const { data } = this.props;

        return (
            <div className={b()}>
                <SectionGridRow ratios="33-66">
                    <div className={b('left')}>
                        {data.first.facts.map((fact, i: number) => (
                            <Card
                                theme="white"
                                location="inner"
                                stretched
                                key={`card-${i}`}
                            >
                                <Title h3={fact} />
                            </Card>
                        ))}
                    </div>

                    <CardDigit theme="white" data={data.first.digit} />
                </SectionGridRow>

                <SectionGridRow>
                    {data.second.facts.map((fact, i: number) => (
                        <Card
                            theme="white"
                            location="inner"
                            stretched
                            key={`card-${i}`}
                            hint={Boolean(fact.tooltip)}
                        >
                            <Title h3={fact.title} />

                            {fact.tooltip && (
                                <div className={b('hint-icon')}>
                                    <HintIcon
                                        hint={fact.tooltip}
                                        mixClassName={b('hint')}
                                        width={380}
                                    />
                                </div>
                            )}
                        </Card>
                    ))}
                </SectionGridRow>
            </div>
        );
    }
}
