import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Card from 'client/components/card';
import Title from 'client/components/title';

import './index.css';

const b = cn('principles');

interface Props {
    items: TextItem[];
}

export default class Principles extends Component<Props> {
    renderItem = (item: TextItem, i: number): React.ReactNode => {
        return (
            <Card theme="light-grey" key={`card-${i}`}>
                <div className={b('item')}>
                    <div className={b('title')}>
                        <Title h3={item.title} />
                    </div>
                    <div className={b('text')}>{item.text}</div>
                </div>
            </Card>
        );
    };

    render(): React.ReactNode {
        const { items } = this.props;

        return <div className={b()}>{items.map(this.renderItem)}</div>;
    }
}
