import React, { Component } from 'react';

import cn from 'client/utils/cn';
import SectionGridColumn from 'client/components/section-grid-column';

import './index.css';

const b = cn('privacy-other');

interface Props {
    other: BunkerPageSecurity['sections']['privacy']['other'];
}

export default class PrivacyOther extends Component<Props> {
    render(): React.ReactNode {
        const { other } = this.props;

        return (
            <div className={b()}>
                <SectionGridColumn
                    theme="light-grey"
                    icon="shield"
                    left={other.items.left}
                    right={other.items.right}
                />
            </div>
        );
    }
}
