import React, { Component } from 'react';

import cn from 'client/utils/cn';

import './index.css';

const b = cn('report-download');

interface Props {
    report: BunkerCommon['report'];
}

export default class ReportDownload extends Component<Props> {
    render(): React.ReactNode {
        const { report } = this.props;

        return (
            <a
                className={b()}
                href={report.url}
                target="_blank"
                rel="noopener noreferrer"
            >
                <span className={b('icon')} />
                {report.title}
                {report.size && (
                    <span className={b('size')}>{`(${report.size})`}</span>
                )}
            </a>
        );
    }
}
