import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Card from 'client/components/card';
import ImageCard from 'client/components/image-card';
import SectionGridRow from 'client/components/section-grid-row';

import './index.css';

const b = cn('row-fact-image');

interface Props {
    ratios: '33-66' | '66-33';
    theme: 'white' | 'light-grey';
    children: React.ReactNode;
    image: string;
}

export default class RowFactImage extends Component<Props> {
    render(): React.ReactNode {
        const { image, ratios, theme, children } = this.props;

        return (
            <div className={b()}>
                <SectionGridRow ratios={ratios}>
                    {ratios === '66-33' ? children : null}

                    <div className={b('image')}>
                        <Card theme={theme} location="inner" stretched>
                            <ImageCard title="" src={image} hidden />
                        </Card>
                    </div>

                    {ratios === '33-66' ? children : null}
                </SectionGridRow>
            </div>
        );
    }
}
