import React, { Component } from 'react';

import CardFact from 'client/components/card-fact';
import cn from 'client/utils/cn';
import Card from 'client/components/card';
import Icon from 'client/components/icon';
import Link from 'client/components/link';
import Notes from 'client/components/notes';
import Title from 'client/components/title';

import './index.css';

const b = cn('section-agenda-stream');

interface Props {
    item: StreamItem;
    dictionary: StreamDictionary;
    contributions: StreamDictionary;
}

export default class SectionAgendaStream extends Component<Props> {
    renderGoal = (goal: string, i: number): React.ReactNode => {
        const { dictionary } = this.props;

        return (
            <CardFact
                theme="light-grey"
                key={`card-fact-${i}`}
                location="inner"
                title={dictionary.goal}
                text={goal}
            />
        );
    };

    renderCard = (card: StreamCard, index: number): React.ReactNode => {
        const { dictionary, contributions } = this.props;

        return (
            <Card theme="white" key={`card-${index}`}>
                <div className={b('card')}>
                    <div className={b('card-left')}>
                        <div className={b('type')}>{dictionary[card.type]}</div>

                        <div className={b('card-title')}>
                            <Title h3={card.title} />
                        </div>

                        <div className={b('icons')}>
                            {card.contribution.map((num, i: number) => (
                                <Icon
                                    type={`contribution-${num}`}
                                    key={`icon-${i}`}
                                    size="44"
                                    title={contributions[num]}
                                />
                            ))}
                        </div>
                    </div>

                    <div className={b('card-right')}>
                        <div className={b('goals')}>
                            {card.goal.map(this.renderGoal)}
                        </div>

                        <Notes
                            items={card.metrics}
                            title={dictionary.metrics}
                        />
                    </div>

                    <div className={b('card-link')}>
                        <Link
                            href={card.link}
                            text={dictionary.link}
                            icon="inside"
                        />
                    </div>
                </div>
            </Card>
        );
    };

    render(): React.ReactNode {
        const { item } = this.props;

        return <div className={b()}>{item.cards.map(this.renderCard)}</div>;
    }
}
