import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Card from 'client/components/card';
import Link from 'client/components/link';
import SectionGridRow from 'client/components/section-grid-row';
import Title from 'client/components/title';

import './index.css';

const b = cn('section-datacenters');

interface Props {
    datacenters: BunkerPageEnergy['sections']['datacenters'];
}

export default class SectionDatacenters extends Component<Props> {
    renderLocationCard = (
        location: DatacenterLocation,
        i: number
    ): React.ReactNode => {
        return (
            <Card theme="light-grey" key={`card-${i}`}>
                <div className={b('country')}>{location.country}</div>

                <Title h3={location.names} />
            </Card>
        );
    };

    render(): React.ReactNode {
        const {
            datacenters: { locations, link }
        } = this.props;

        return (
            <div className={b()}>
                <SectionGridRow ratios="66-33">
                    {locations.map(this.renderLocationCard)}
                </SectionGridRow>

                {link.text && link.url && (
                    <div className={b('link')}>
                        <Link text={link.text} href={link.url} icon="outside" />
                    </div>
                )}
            </div>
        );
    }
}
