import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Icon from 'client/components/icon';
import Title from 'client/components/title';
import Card from 'client/components/card';
import CardFact from 'client/components/card-fact';
import LangContext from 'client/utils/lang-context';
import Notes from 'client/components/notes';
import SectionGridRow from 'client/components/section-grid-row';

import './index.css';

const b = cn('section-education-areas');

interface Props {
    item: AreasItem;
}

export default class SectionEducationAreas extends Component<Props> {
    static contextType = LangContext;

    render(): React.ReactNode {
        const { item } = this.props;
        const { dictionary } = this.context;

        return (
            <Card theme="light-grey">
                <div className={b()}>
                    <div className={b('title')}>
                        <Icon type="book" size="52" />

                        <Title h3={item.title} />
                    </div>

                    <div className={b('facts')}>
                        <SectionGridRow>
                            {item.facts.map((fact, index) => (
                                <CardFact
                                    theme="white"
                                    key={`facts-card-${index}`}
                                    location="inner"
                                    title={fact.title}
                                    text={fact.text}
                                    stretched
                                />
                            ))}
                        </SectionGridRow>
                    </div>

                    <Notes
                        items={item.projects}
                        title={dictionary.keyProjects}
                    />
                </div>
            </Card>
        );
    }
}
