import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Docs from 'client/components/docs';
import Title from 'client/components/title';
import SectionCardTabs from 'client/components/section-card-tabs';

import './index.css';

const b = cn('section-education-initiatives');

interface Props {
    initiatives: BunkerPageEducation['sections']['initiatives'];
}

export default class SectionEducationInitiatives extends Component<Props> {
    render(): React.ReactNode {
        const {
            initiatives: { reports, items, segalovich }
        } = this.props;
        const hasSegalovich =
            segalovich.title && segalovich.period && segalovich.text;

        return (
            <div className={b()}>
                <SectionCardTabs
                    items={hasSegalovich ? [segalovich, ...items] : items}
                    theme="white"
                />

                {reports.items.length > 0 && (
                    <div className={b('reports')}>
                        <div className={b('reports-title')}>
                            <Title h4={reports.title} />
                        </div>

                        <div className={b('reports-docs')}>
                            <Docs items={reports.items} theme="white" />
                        </div>
                    </div>
                )}
            </div>
        );
    }
}
