import React, { Component } from 'react';

import cn from 'client/utils/cn';
import CardFact from 'client/components/card-fact';
import ImageCard from 'client/components/image-card';

import './index.css';

const b = cn('section-grid-column');

interface SectionGridColumnItem {
    title: string;
    text: string;
    image?: string;
    popup?: string;
    facts?: any[];
}

interface Props {
    left: SectionGridColumnItem[];
    right: SectionGridColumnItem[];
    theme: 'white' | 'light-grey';
    icon?: string;
}

export default class SectionGridColumn extends Component<Props> {
    renderItems = (itemsArray: SectionGridColumnItem[]): React.ReactNode => {
        const { theme, icon } = this.props;

        return itemsArray.map((item, index) => (
            <div key={index} className={b('item')}>
                <CardFact
                    theme={theme}
                    key={index}
                    title={item.title}
                    text={item.text}
                    icon={icon}
                    iconSize="52"
                    stretched
                    popup={item.popup}
                >
                    {this.renderFacts(item.facts)}

                    {item.image && (
                        <ImageCard src={item.image} title={item.title} hidden />
                    )}
                </CardFact>
            </div>
        ));
    };

    renderFacts = (facts: any[] | undefined): React.ReactNode => {
        if (!facts || !facts.length) {
            return null;
        }

        return (
            <div className={b('facts')}>
                {facts.map((fact, index) => (
                    <CardFact
                        theme="light-grey"
                        key={index}
                        location="inner"
                        title={fact.title}
                        text={fact.text}
                    />
                ))}
            </div>
        );
    };

    render(): React.ReactNode {
        const { left, right } = this.props;

        return (
            <div className={b()}>
                <div className={b('stack')}>{this.renderItems(left)}</div>
                <div className={b('stack')}>{this.renderItems(right)}</div>
            </div>
        );
    }
}
