import React, { Component } from 'react';

import cn from 'client/utils/cn';

import './index.css';

const b = cn('section-grid-row');

interface Props {
    children?: React.ReactNode[] | null;
    ratios?: '33-66' | '66-33';
}

export default class SectionGridRow extends Component<Props> {
    render(): React.ReactNode {
        const { children, ratios } = this.props;
        const items = React.Children.toArray(children);

        if (items.length === 0) {
            return null;
        }

        return (
            <div className={b({ ratios })}>
                {items.map((item, index) => (
                    <div key={index} className={b('item')}>
                        {item}
                    </div>
                ))}
            </div>
        );
    }
}
