import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Card from 'client/components/card';
import CardFact from 'client/components/card-fact';
import LangContext from 'client/utils/lang-context';
import Link from 'client/components/link';
import Title from 'client/components/title';

import './index.css';

const b = cn('section-main-result');

interface Props {
    results: BunkerPageMain['results'];
}

export default class SectionMainResult extends Component<Props> {
    static contextType = LangContext;

    render(): React.ReactNode {
        const { results } = this.props;

        return (
            <div className={b()}>
                <div className={b('title')}>
                    <span>{results.year}</span>
                    <Title h2={results.title} />
                </div>

                <div className={b('link')}>
                    <Link
                        href={results.link.url}
                        text={results.link.text}
                        icon="inside"
                        bg
                    />
                </div>

                <div className={b('chapters')}>
                    <Card theme="white">
                        <div className={b('items')}>
                            {results.items.map((item, index) => (
                                <div key={index} className={b('item')}>
                                    <CardFact
                                        theme="white"
                                        key={`facts-card-${index}`}
                                        icon={item.icon}
                                        iconSize="32"
                                        title={item.title}
                                        text={item.text}
                                        url={item.url}
                                        nodecorate
                                        stretched
                                    />
                                </div>
                            ))}
                        </div>
                    </Card>
                </div>
            </div>
        );
    }
}
